/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.text.MessageFormat;
import java.util.Locale;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;

public class SystemProperties
extends Resource {
    private static SystemProperties instance = null;

    public static SystemProperties getInstance() {
        if (instance == null && (instance = ProxyFactory.getInstance().createProxy(SystemProperties.class)) == null) {
            instance = new SystemProperties();
        }
        return instance;
    }

    protected SystemProperties() {
        super("SYSTEM_PROPERTIES", null);
    }

    @Override
    public String getProperty(String key, Object ... args) {
        String value = System.getProperty(key);
        if (value != null && args != null && args.length > 0) {
            value = MessageFormat.format(value, args);
        }
        return value;
    }

    @Override
    protected final void reload(Locale locale) {
    }

    @Override
    public void setProperty(String key, Object value) {
        String _value = null;
        if (value instanceof String) {
            _value = (String)value;
        } else if (value != null) {
            _value = value.toString();
        }
        System.setProperty(key, _value);
    }

    @Override
    public void removeProperty(String key) {
        System.clearProperty(key);
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }
}

